<?php

header('Access-Control-Allow-Origin: *');
header( 'Access-Control-Allow-Headers: Authorization, Content-Type' );
header('Access-Control-Allow-Methods: POST, GET, OPTIONS, PUT, DELETE');

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
// Access-Control-Allow-Origin: http://siteA.com

// header('Access-Control-Allow-Origin: *');
// header( 'Access-Control-Allow-Headers: Authorization, Content-Type' );
// header('Access-Control-Allow-Credentials: true');

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::group(['prefix' => 'v1'], function () {
    Route::post('auth/login','Services\AuthController@login');
    Route::resource('register-user', 'Services\UserController');
    Route::post('checkuser', 'Services\UserController@checkUser');
    Route::group(['middleware' => 'auth:api'],function(){
        // Content //
        Route::resource('article', 'Services\ContentsController');
        Route::resource('course', 'Services\CourseController');
        Route::resource('uniform', 'Services\UniformController');
        Route::resource('admission', 'Services\AdmissionController');

        // User //
        Route::resource('users', 'Services\UserController');
        Route::post('users/checkuser', 'Services\UserController@checkUser');
        Route::get('auth/get-user','Services\AuthController@getUser');
        Route::get('auth/logout' ,'Services\AuthController@logout');
        Route::post('auth/logout' ,'Services\AuthController@logout');
    });
    Route::group(['prefix' => 'front'], function () {
        Route::get('uniform','Services\ApiController@uniform');
        Route::get('article','Services\ApiController@article');
        Route::get('education','Services\ApiController@education');
    });
});
