import Vue from "vue";
import Vuex from "vuex";
import Axios from 'axios'

Vue.use(Vuex);

export const store = new Vuex.Store({
  state: {
    base_api: '/api/v1/',
    base_url : window.location.hostname == 'localhost' ? 'http://localhost:8000' : `http://${window.location.hostname}`,
    authen : {},
    header_bearer : {'Authorization': `Bearer ${localStorage.getItem('tokenAccess')}`},
    req : Axios.create({
        baseURL: '/',
        timeout: 0,
        headers: {'Authorization': `Bearer ${localStorage.getItem('tokenAccess')}`}
    }),
    tinyKey : '3rhe8ho2jknd1srco7cwk4t4iu1c1pbvj3ine89vquy8ynzh'

  },

  mutations: {
      checked(state){
        let req = state.req
        let url = state.base_api + 'auth/get-user'
        req.get(url)
            .then(response => {
                let user = response['data'];
                state.authen = user;
                console.log('user data : ', user );
            })
            .catch( error => {
                localStorage.clear();
                location.href = '/backend/login';
            });
      },
      set_auth(state,value){
            state.authen = value;
      }
  },

  actions: {
      upateAuthen(context){
        //   console.log('update state');
          context.commit('checked');
      }
    // addFood({ commit }, payload) {
    //   commit("addFood", { payload });
    // },
  },

  getters: {
    req: state => state.req,
    base_api : state => state.base_api,
    base_url : state => state.base_url,
    authen : state => state.authen,
    tinyKey : state => state.tinyKey,
    header : state => state.header_bearer,
  }
});
