import Axios from 'axios';
export default {
    name: 'Stat',
    data() {
        return {
            req : Axios.create({
                baseURL: '/',
                headers: {'Authorization': `Bearer ${localStorage.getItem('tokenAccess')}`}
            })
        }
    },
    methods: {
        record(){
            const tokenAccess = localStorage.getItem('tokenAccess');
            let to = this.$route;

                let stat_url = '/api/v1/front/stat';
                let stat_params = {
                    token: tokenAccess,
                    url :  window.location.href,
                    page : to.name,
                    article_id: ( to.name == 'knowleage-view' || to.name == 'article-view' ) ? to.params.id  : 0
                }
                // console.log('stat params : ', stat_params);
                this.req.post(stat_url,stat_params).then( response => {

                });
        },
        logs(activity){
            let to = this.$route;

                let logs_url = '/api/v1/logs';
                let logs_params = {
                    url :  window.location.href,
                    activity : activity
                }
                // console.log('stat params : ', stat_params);
                this.req.post(logs_url,logs_params).then( response => {

                });

        }
    },
}
