import Router from 'vue-router';
import Vue from 'vue';
import Template from '../layouts/TemplateComponent'
import Goals from '../app/contents/goal'
import Study from '../app/contents/study'
import StudyJapan from '../app/contents/study-japan'
import Scholarship from '../app/contents/scholarship'
import Management from '../app/contents/management'
import Education from '../app/contents/education'
import CourseExplain from '../app/course/course-explain'
import CourseList from '../app/course/course-list'
import CourseForm from '../app/course/course-form'
import Uniform from '../app/uniforms/uniform-list'
import User from '../app/users/User'
import UserForm from '../app/users/UserForm'
import Login from '../app/auth/Login'
import Logout from '../app/auth/logout'
import Dashboard from '../static/DashboardComponent'
Vue.use(Router);

export default new Router({
        mode : 'history',
        routes: [
            {
                path: '/backend/login',
                name: 'Login',
                component: Login,
            },
            {
                path: '/backend/logout',
                name: 'user-logout',
                component: Logout,
            },

            {
                path: '/backend',
                component: Template,
                redirect: {name : 'Login'},
                children:[
                    {
                        path : '',
                        redirect: {name : 'dashboard'},
                    },

                    {
                        path: 'dashboard',
                        name: 'dashboard',
                        component: Dashboard,
                        meta : {
                            title : 'Dashboard',
                            breadcrumb : [],
                            level : ['admin','writer']
                        }
                    },
                    {
                        path: 'contents/goals',
                        name: 'goals',
                        component: Goals,
                        meta : {
                            title : 'เป้าหมายการพัฒนานักเรียน',
                            breadcrumb : [
                                { name: 'เป้าหมายการพัฒนานักเรียน' }
                            ],
                            level : ['admin']

                        }
                    },
                    {
                        path: 'course/explain',
                        name: 'course-explain',
                        component: CourseExplain,
                        meta : {
                            title : 'รายละเอียดหลักสูตร',
                            breadcrumb : [
                                { name: 'รายละเอียดหลักสูตร' }
                            ],
                            level : ['admin']

                        }
                    },
                    {
                        path: 'course/list',
                        name: 'course-list',
                        component: CourseList,
                        meta : {
                            title : 'หัวข้อหลักสูตร',
                            breadcrumb : [
                                { name: 'หัวข้อหลักสูตร' }
                            ],
                            level : ['admin']

                        }
                    },
                    {
                        path: 'course/add',
                        name: 'course-add',
                        component: CourseForm,
                        meta : {
                            title : 'เพิ่มหัวข้อหลักสูตร',
                            breadcrumb : [
                                { name: 'หัวข้อหลักสูตร' , url : '/backend/course-list' },
                                { name: 'เพิ่มหัวข้อหลักสูตร' }
                            ],
                            level : ['admin']

                        }
                    },
                    {
                        path: 'course/:id/edit',
                        name: 'course-edit',
                        component: CourseForm,
                        meta : {
                            title : 'แก้ไขหัวข้อหลักสูตร',
                            breadcrumb : [
                                { name: 'หัวข้อหลักสูตร' , url : '/backend/course-list' },
                                { name: 'แก้ไขหัวข้อหลักสูตร' }
                            ],
                            level : ['admin']

                        }
                    },
                    {
                        path: 'contents/study',
                        name: 'study',
                        component: Study,
                        meta : {
                            title : 'ระยะเวลาการเรียนและวุฒิการศึกษา',
                            breadcrumb : [
                                { name: 'ระยะเวลาการเรียนและวุฒิการศึกษา' }
                            ],
                            level : ['admin']

                        }
                    },
                    {
                        path: 'contents/study-japan',
                        name: 'study-japan',
                        component: StudyJapan,
                        meta : {
                            title : 'การเรียนรู้ ณ ประเทศญี่ปุ่น',
                            breadcrumb : [
                                { name: 'การเรียนรู้ ณ ประเทศญี่ปุ่น' }
                            ],
                            level : ['admin']

                        }
                    },

                    {
                        path: 'uniform/list',
                        name: 'uniform',
                        component: Uniform,
                        meta : {
                            title : 'เครื่องแบบนักเรียน',
                            breadcrumb : [
                                { name: 'เครื่องแบบนักเรียน' }
                            ],
                            level : ['admin']
                        }
                    },

                    {
                        path: 'scholarship',
                        name: 'scholarship',
                        component: Scholarship,
                        meta : {
                            title : 'ทุนการศึกษา',
                            breadcrumb : [
                                { name: 'ทุนการศึกษา' }
                            ],
                            level : ['admin']

                        }
                    },
                    {
                        path: 'management',
                        name: 'management',
                        component: Management,
                        meta : {
                            title : 'หน่วยงานบริหารจัดการ',
                            breadcrumb : [
                                { name: 'หน่วยงานบริหารจัดการ' }
                            ],
                            level : ['admin']

                        }
                    },
                    {
                        path: 'education',
                        name: 'education',
                        component: Education,
                        meta : {
                            title : 'การเข้าศึกษาต่อ',
                            breadcrumb : [
                                { name: 'การเข้าศึกษาต่อ' }
                            ],
                            level : ['admin']

                        }
                    },
                    {
                        path: 'user',
                        name: 'user-list',
                        component: User,
                        meta : {
                            title : 'User info list',
                            breadcrumb : [
                                { name: 'User' }
                            ],
                            level : ['admin']

                        }
                    },
                    {
                        path: 'user-form',
                        name: 'user-form',
                        component: UserForm,
                        meta : {
                            title : 'Add new user',
                            breadcrumb : [
                                { name: 'User' , url : '/backend/user' },
                                { name: 'User form', className:'active'  }
                            ],
                            level : ['admin']

                        }
                    },
                    {
                        path: 'user-edit/:id',
                        name: 'user-edit',
                        component: UserForm,
                        meta : {
                            title : 'Edit user',
                            breadcrumb : [
                                { name: 'User' , url : '/backend/user' },
                                { name: 'User update', className:'active'  }
                            ],
                            level : ['admin']

                        }
                    },
                ]
            },

        ]
    })
