/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

require('./bootstrap');

window.Vue = require('vue');
import Axios from 'axios'

import {store} from './stores/store';
import Router from './backend/router/routes';
import BootstrapVue from 'bootstrap-vue'
import ToggleButton from 'vue-js-toggle-button'

import 'bootstrap/dist/css/bootstrap.css'
import 'bootstrap-vue/dist/bootstrap-vue.css'
import 'font-awesome/css/font-awesome.min.css'
import 'simple-line-icons/css/simple-line-icons.css'
import moment from 'moment';
import VueSweetalert2 from 'vue-sweetalert2';

const router = Router
router.beforeEach((to, from, next) => {
    if (to.name !== 'Login' ){
        // console.log('router to : ', to);
        const tokenAccess = localStorage.getItem('tokenAccess');
        let userInfo = localStorage.getItem('userInfo');

        if( !tokenAccess ) return next({ name: 'Login' });
        if( !userInfo ){
            console.log('user info false :', userInfo);
        let url = store.getters.base_api + 'auth/get-user'
        Axios.create({
            baseURL: '/',
            timeout: 1000,
            headers: {'Authorization': `Bearer ${localStorage.getItem('tokenAccess')}`}
        })
        .get(url)
            .then(response => {
                let user = response['data'];
                    localStorage.setItem('userInfo',JSON.stringify(user) );
                    store.commit('set_auth',user);
                    next();
            },
            error => {
                const {status} = error.response;
                if (status === 401) {
                    // console.log('error status 401');
                    localStorage.clear();
                    next({ name: 'Login' });
                }
            })
            .catch( error => {
                // console.log('error ', error.message);
                localStorage.clear();
                next({ name: 'Login' });
            });
        }else{
            console.log('has user info');
            // state.authen = JSON.parse(userInfo);
            next();
        }
    } else {
        const tokenAccess = localStorage.getItem('tokenAccess');
        if( tokenAccess ) return next({ name: 'dashboard' });
        next()
    }
});

Vue.use(BootstrapVue);
Vue.use(ToggleButton);
Vue.use(VueSweetalert2);

Vue.use(require('vue-moment'));

Vue.component('app-component',require('./appComponent.vue').default);
Vue.filter('dateThai', function(value ) {
    if (value) {
        let exdate = moment(String( value)).format('YYYY-MM-DD');
        let edx     = exdate.split('-');
        // console.log('formate date value ', exdate );
        let mthai = ['','ม.ค.','ก.พ.','มี.ค.','เม.ย.','พ.ค.','มิ.ย.','ก.ค.','ส.ค.','ก.ย.','ต.ค.','พ.ย.','ธ.ค.'];
        let y    = Number(edx[0])+543;
        let m   = mthai[ parseInt(edx[1]) ];
        let d    = edx[2];
      return String(`${d} ${m} ${y}`)
    }
});

Vue.filter('showTime', function(value ) {
    if (value) {
        let exdate = moment(String( value)).format('YYYY-MM-DD HH:mm:ss');
        let edx     = exdate.split(' ');
        // console.log('show time : ', edx);
        if( edx.length == 2 ){
            let tx = edx[1].split(':');
            // console.log('tx : ', tx);
            return String(`${tx[0]}:${tx[1]}`);
        }
      return String(``)
    }
});

Vue.filter('dateThaiRang', function( value ) {
    if (value) {
        // let exdate = moment(String(value)).format('YYYY-MM-DD');
        let rang    = value.split('-');
        let start   = rang[0].split('/');
        let end     = rang[1].split('/');
        // console.log('formate date value ', exdate );
        let mthai = ['','ม.ค.','ก.พ.','มี.ค.','เม.ย.','พ.ค.','มิ.ย.','ก.ค.','ส.ค.','ก.ย.','ต.ค.','พ.ย.','ธ.ค.'];
        let startDate    = start[0] + ' '
                         + mthai[ parseInt( start[1] ) ] + ' '
                         + ( Number(start[2])  + 543 ) ;

        let endDate    = end[0] + ' '
                         + mthai[ parseInt( end[1] ) ] + ' '
                         + ( Number( end[2]) + 543 );

      return String(`${startDate} - ${endDate}`);
    }
});
const backend = new Vue({
    router,
    store,
    el: '#app',
});
