<?php

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;

function printr($arr){
        echo '<pre>', print_r( $arr ) ,'</pre>';
    }

    function makedir_storage($path){
        if( !file_exists($path) ){
            Storage::makeDirectory($path,0777,true,true);
        }
        return $path;
    }

    function makedir($path){
        if( !File::exists($path) )
            File::makeDirectory($path, 0777, true);
        return $path;
    }

    function RangToDate($date,$type){
        $date = explode('/',$date);
        $setDate = "$date[2]-$date[1]-$date[0] " .( $type == 'start' ? '00:00:00': '23:59:59');
        return date('Y-m-d H:i:s', strtotime( $setDate ) );
    }

    function dateTh($strDate){
        $strYear = date("Y",strtotime($strDate))+543;
		$strMonth= date("n",strtotime($strDate));
		$strDay= date("j",strtotime($strDate));
		$strHour= date("H",strtotime($strDate));
		$strMinute= date("i",strtotime($strDate));
		$strSeconds= date("s",strtotime($strDate));
		$strMonthCut = Array("","มกราคม.","กุมพาพันธ์","มีนาคม","เมษายน","พฤษภาคม","มิถุนายน","กรกฎาคม","สิงหาคม","กันยายน","ตุลาคม","พฤศจิกายน","ธันวาคม");
		$strMonthThai=$strMonthCut[$strMonth];
		return "$strDay $strMonthThai $strYear";
    }
    function dateEn($strDate){
        return date('d F Y', strtotime( $strDate ) );
    }

    function showDate($strDate){
        if( App::getLocale() == 'th'){
           return  dateTh($strDate);
        }else{
           return  dateEn($strDate);
        }
    }

    function filename($path,$file,$x=1){
        $fullpath = $path .'/'. $file;
        if( file_exists( $fullpath ) ){
            $oldname   = pathinfo($file, PATHINFO_FILENAME);
            $ext = '.' . extensionfile( $file );
            $exname     = explode('-',$oldname);
            $last       = count($exname) -1;
            $lastname   = $exname[$last];
            if( strlen($lastname) <= 2 ) {
                $exname[$last] = $x;
            }else{
                $exname[] = $x;
            }

            $filename   = implode('-',$exname)  . $ext;
            return filename( $path,$filename,$x+1);
        }
        return $file;
    }
    function baseExt($basefile){
        if( !$basefile ) return 'jpg';
        $base = explode(';',$basefile);
        $ex = explode('/',$base[0]);
        return count($ex) > 1 ? $ex[1] : 'jpg';
    }

    function alfa_name($name){
        $name = str_replace('@','-',$name);
        $name = str_replace('.','-',$name);
        return $name;
    }
    function encodelink($name){
        $name = str_replace('@','-',$name);
        $name = str_replace('.','-',$name);
        $name = str_replace(' ','-',$name);
        $name = str_replace('/','-',$name);
        $name = str_replace(',','-',$name);
        return $name;
    }

    function extensionfile($file ){
        return pathinfo($file, PATHINFO_EXTENSION);
    }

    function jsonEncode($arr){
        return json_encode($arr, JSON_UNESCAPED_UNICODE);
    }

    function baseImg($basefile){
        $image  = str_replace('data:image/png;base64,', '', $basefile);
        $image  = str_replace('data:image/jpg;base64,', '', $image);
        $image  = str_replace('data:image/jpeg;base64,', '', $image);
        $image  = str_replace(' ', '+', $image);
        return $image;
    }

    function category_flow($categoryId,$categories){
        if( !$categoryId ) return ['main' => '','sub' => ''];
        $cateId = json_decode( $categoryId );
        $numrows = count($cateId);
        $main = [];
        $flows = [];
        if( !$categories || !$cateId ) return ['main' => '','sub' => ''];;
        $categories = json_decode( jsonEncode($categories) );

        foreach( $categories as $cate ){
            // printr($cate);
            if( $cate->id == $cateId[0] ){
                $main = $cate;
                $flows['main'] = $cate->name;
                break;
            }
        }
        // printr($main);
        $sub = [];
        if( $numrows >= 2 && $main ){
            $ref1 = $main->refs;
            $lv1  = getFor($ref1, $cateId[1] );
            // echo 'level 1 ';
            // printr($lv1);
            $sub[] = $lv1->name;
            if( $numrows >= 3 && $lv1->refs ){
                $ref2 = $lv1->refs;
                $lv2  = getFor($ref2, $cateId[2] );
                $sub[] = $lv2->name;
                if( $numrows >= 4 && $lv2->refs ){
                    $ref3 = $lv2->refs;
                    $lv3 = getFor($ref3, $cateId[3] );;
                    $sub[] = $lv3->name;
                    if( $numrows >= 5 && $lv3->refs ){
                        $ref4 = $lv3->refs;
                        $lv4  = getFor($ref4, $cateId[4] );
                        $sub[] = $lv4->name;
                    }
                }
            }
        }
        $flows['sub'] = $sub ? implode(' > ', $sub) : '';
        return $flows;
    }

    function getFor($arrs,$id){
        $data = '';
        if( !$arrs ) return '';
        foreach( $arrs as $arr ){
            if( $arr->id == $id ){
                $data = $arr;
                break;
            }
        }
        return $data;
    }

    function checkExists($img){
        if( extensionfile($img) == '' || !file_exists($img) ) return false;
        return true;
    }

    function exitsImage($img,$noimg = 'assets/images/no-image.png'){
        if( extensionfile($img) == '' || !file_exists($img) ) return $noimg;
        return $img;
    }

    function showText($field,$node = '',$length = 0){
        $lang = App::getLocale();
        $data = @json_decode($field);
        if( $node != '' ){
            $str =  @$data->$lang->$node;
        }else{
            $str = @$data->$lang;
        }
        return $length > 0 ? mb_substr( $str,0,$length ) : $str;
    }
