<?php
    function user_field($row){
        return [
                'id' => $row->id,
                'email' => $row->email,
                'password' => $row->password,
                'name' => $row->name,
                'type' => $row->type,
                'avatar' => $row->avatar,
                'imageAvatar' => ($row->avatar ? asset('assets/images/avatar/'. $row->avatar) : ''),
                'favorite' =>  $row->favorite ,
                'readed' =>  $row->readed ,
                'role' => $row->role,
                'status' => $row->status,
                'remember_token' => $row->remember_token,
                'created_at' => $row->created_at,
                'updated_at' => $row->updated_at,
        ];
    }

    function user_rows($rows){
        $data = [];
        if( $rows ){
            foreach($rows as $row){
                $data[] = user_field($row);
            }
        }
        return $data;
    }


    function files_rows($rows){
        $data = [];
        if( $rows ){
            foreach($rows as $idx => $row){
                $data[] = files_field($row,$idx);
            }
        }
        return $data;
    }

    function files_field($row, $i = 0){
        if( !$row ) return [];
        return [
                'id'            => $row->id,
                'ref_id'        => $row->ref_id,
                'filename'      => $row->filename,
                'path'          => $row->path,
                'link'          => $row->link,
                'subject'          => $row->subject,
                'description'          => $row->description,
                'file'          => ( checkExists( $row->path .'/'. $row->filename ) ) ? asset( $row->path . '/' . $row->filename) : asset( 'assets/images/no-image.png' ),
                'sortable'      => $row->sortable,
                'type'          => $row->type,
                'refs'          => $row->refs,
                'published'     => $row->published,
                'active'     => $i == 0 ? 'true' : 'false',
                'created_at'    => $row->created_at,
                'updated_at'    => $row->updated_at
        ];
    }

    function article_rows($rows){
        $data = [];
        if( $rows ){
            foreach($rows as $row){
                $data[] = article_field($row);
            }
        }
        return $data;
    }

    function article_field($row){
        return [
                'id'            => $row->id,
                'subject'       => $row->subject,
                'description'   => $row->description,
                'detail'        => $row->detail,
                'viewed'        => $row->viewed,
                'sortable'      => $row->sortable,
                'type'          => $row->type,
                'user_id'       => $row->user_id,
                'published'     => $row->published,
                'created_at'    => $row->created_at,
                'updated_at'    => $row->updated_at
        ];
    }
