<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Article extends Model
{
    protected $table = 'articles';

    public function scopeType($query,$type){
        return $query->where('type',$type);
    }
    public function scopeActive($query){
        return $query->where('published',1);
    }
    public function user()
    {
        return $this->hasOne('App\User','id','user_id');
    }
}
