<?php

namespace App\Http\Controllers\Services;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\User;
use App\Models\Logs;
use App\Models\Category;
use Illuminate\Support\Facades\Hash;
use Exception;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class UserController extends Controller
{
    public function __construct()
    {
        $this->path_avatar = 'assets/images/avatar/';
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try{
            if( $request->input('keywords') ){
                $keywords = $request->input('keywords');
                $rows = User::where(function($query) use ($keywords){
                        $keys = explode(' ', $keywords);
                        foreach( $keys as $key){
                            $query->where('name','like','%'. $key .'%');
                        }
                    })->orderBy('name');
            }else{
                $rows = User::orderBy('name');
            }
            $rows = $rows->paginate(24);

            return response()->json([
                'data'          => user_rows($rows),
                'lastPage'      => $rows->lastPage(),
                'currentPage'   => $rows->currentPage(),
                'perPage'       => $rows->perPage(),
                'totalRows'     => $rows->total(),
                'code'          => 200

            ],200);
        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try{
            // return response()->json($request->all());
        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // printr($request->all());

        try{
            if( $c = User::where('email',$request->input('email'))->first() )
                return response()->json(['code' => 204, 'message' => 'The username already exists. Please use a different username'],204);
            $user = new User;
            $user->email    = $request->input('email');
            $user->password = Hash::make($request->input('password'));
            $user->name     = $request->input('name');
            $user->type    =  $request->input('type'); //'admin';
            $user->status   = $request->input('status') == true ? 'active' : 'inactive';
            $user->avatar = '';
            if( $request->input('avatar') && $request->input('avatar') != 'null'){
                $file       = $request->input('avatar');
                $filename   = str_replace('@','-',$request->input('email'));
                $filename   = str_replace('.','-',$filename). '.' . baseExt($file);
                File::put($this->path_avatar . $filename, base64_decode($file));
                $user->avatar = $filename;
            }
            $user->save();

            return response()->json(['code' => 200, 'data' => user_field($user)],200);
        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try{
            $user = User::find($id);
            return response()->json(['code' => 200, 'data' => user_field($user)],200);
        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // printr($request->all());

        try{
            $activity = [];
            $user = User::find($id);
            if( $user->email != $request->input('email') ){
                if( $c = User::where('email',$request->input('email'))->first() )
                return response()->json(['code' => 204, 'message' => 'The username already exists. Please use a different username']);
            }
            $user->email = $request->input('email');
            if( $request->input('password') && $request->input('password') != 'null')
                $user->password = Hash::make($request->input('password'));
            $user->name = $request->input('name');
            $user->status   =  $request->input('status')  ? 'active' : 'inactive';
            if( $request->input('avatar') && $request->input('avatar') != 'null'){
                $file       = $request->input('avatar');
                $filename   = str_replace('@','-',$request->input('email'));
                $filename   = str_replace('.','-',$filename). '.' . baseExt($file);
                File::put( $this->path_avatar  . $filename, base64_decode($file));
                $user->avatar = $filename;
            }
            $user->save();
            return response()->json(['code' => 200, 'data' => user_field($user)],200);
        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }

    }

    public function input($input){
        if( !is_array($input) ){
            $enc = json_decode($input);
            $val = $enc->code;
        }else{
            $val = $input['code'];
        }
        return $val;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
            if( $id == 1 )
                return response()->json(['code' => 401, 'message' => 'Unable to delete account administrator'],200);
            $user = User::find($id);
            $avatar = $this->path_avatar . '/' .$user->avatar;
            if($user->avatar && file_exists($avatar) )
                File::delete($avatar);

            $user->delete();
            return response()->json(['code' => 200, 'message' => 'Delete success'],200);

        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }
    }

    public function checkUser(Request $request){
        try{
            $validator = Validator::make($request->all(), [
                'email' => 'required|unique:users|email',
            ],[
                'name.required' => 'กรุณาทำการป้อนชื่อ',
                'email.required' => 'กรุณาทำการป้อน Email',
                'email.unique' => 'ขออภัย Email นี้ได้ลงทะเบียนไปแล้ว',
                'email.email' => 'ขอภัย รูปแบบ Email ไม่ถูกต้อง',
            ]);

            if ($validator->fails()){
                $error = $validator->errors();
                return response()->json([
                                        'errors'=> [
                                                'email' => $error->first('email'),
                                        ],
                                        'code' => 201
                                    ]);
            }

            if( $c = User::where('email',$request->input('email'))->first() )
                return response()->json(['code' => 204, 'message' => 'ขออภัย E-mail นี้ถูกใช้งานแล้ว']);

            return response()->json(['code' => 200, 'message' => 'สามารถใช้ได้'],200);
        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }
    }
}
