<?php

namespace App\Http\Controllers\Services;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Files;
use Exception;
use Illuminate\Support\Facades\File;

class UniformController extends Controller
{
    public function __construct()
    {
        $this->upload_path = 'assets/images/upload/';
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try{
            $rows = Files::type('uniform')
                            ->orderBy('sortable','asc')
                            ->paginate(24);
            return response()->json([
                'data'          => files_rows($rows),
                'lastPage'      => $rows->lastPage(),
                'currentPage'   => $rows->currentPage(),
                'perPage'       => $rows->perPage(),
                'totalRows'     => $rows->total(),
                'code'          => 200

            ],200);
        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // print_r($request->all());
        try{
            $row = new Files;
            if( $request->hasFile('img_uniform') ){
                $sortable = 0;
                $file   = $request->file('img_uniform');
                $path   =   makedir( $this->upload_path );
                $cname  =  'uniform-'. date('Ymd-his') . '.' . $file->getClientOriginalExtension();
                $filename   = filename( $path , $cname );
                $file->move($path,$filename);
                $row->filename = $filename;

                $row->sortable = $request->input('sortable');
                $row->path = $this->upload_path;
                $row->link = '';
                $row->subject = $request->input('subject');
                $row->description = $request->input('description');
                $row->ref_id = 0;
                $row->type = $request->input('type');
                $row->published = $request['publish'];

                $row->save();

                return response()->json(['id' => $row->id, 'code' => 200]);
            }

        }catch( Exception $e){
            return response()->json([
                'code' => $e->getCode(),
                'message' => 'Errors ' . $e->getMessage()
            ]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{
            $row = Files::find($id);
            if( $request->hasFile('img_uniform') ){
                File::delete($row->path .'/' . $row->filename);
                $file   = $request->file('img_uniform');
                $path   =   makedir( $this->upload_path );
                $cname  =  'uniform-'. date('Ymd-his') . '.' . $file->getClientOriginalExtension();
                $filename   = filename( $path , $cname );
                $file->move($path,$filename);
                $row->filename = $filename;
            }

                $row->sortable = $request->input('sortable');
                $row->path = $this->upload_path;
                $row->link = '';
                $row->subject = $request->input('subject');
                $row->description = $request->input('description');
                $row->ref_id = 0;
                $row->type = $request->input('type');
                $row->published = $request['publish'];

                $row->save();

                return response()->json(['id' => $row->id, 'code' => 200]);

        }catch( Exception $e){
            return response()->json([
                'code' => $e->getCode(),
                'message' => 'Errors ' . $e->getMessage()
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
            $file = Files::find($id);
            if( $file ){
                File::delete($file->path .'/' . $file->filename);
                $file->delete();
            }
            return response()->json(['code' => 200, 'message' => 'Delete success'],200);
        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors (' . $e->getCode() .') '. $e->getMessage(),
                'code'      => 401
            ],401);
        }

    }
}
