<?php

namespace App\Http\Controllers\Services;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Article;
use Exception;
use Illuminate\Support\Facades\File;
use Intervention\Image\Facades\Image;
use App\Models\Files;

class CourseController extends Controller
{
    public $auth;
    public function __construct()
    {
        $this->upload_path = 'uploads/news';
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try{
            $rows = Article::type( 'course-list' );
            if( $request->input('keywords') && $request->input('keywords') != 'null' ){
                    $keywords = $request->input('keywords');
                    $rows = $rows->where(function($query) use ($keywords){
                            $keys = explode(' ', $keywords);
                            foreach( $keys as $key){
                                $query->where('subject','like','%'. $key .'%');
                            }
                        });
            }
            $rows = $rows->orderBy('sortable','asc')->paginate(24);
            return response()->json([
                'data'          => article_rows($rows),
                'lastPage'      => $rows->lastPage(),
                'currentPage'   => $rows->currentPage(),
                'perPage'       => $rows->perPage(),
                'totalRows'     => $rows->total(),
                'code'          => 200

            ],200);
        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors query index (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // printr( $request->all() );
        try{
            $row = new Article;
            $row->viewed = 0;
            $row->type = $request->input('type');
            $this->record($request,$row);
            return response()->json([
                        'code' => 200,
                        'data' => article_field($row)
                    ]);

        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors add (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try{
            // return response()->json($request->all());
            $row = Article::find($id);
            return response()->json([
                        'code' => 200,
                        'data' => article_field( $row )
                    ]);
        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{
            // printr( $request->all() );
            $row = Article::find($id);
            $this->record($request,$row);
            return response()->json([
                        'code' => 200,
                        'data' => article_field($row)
                    ]);
        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
            $idx = explode('-',$id);
            foreach($idx as $i => $delId){
                $res = Article::find($delId);
                if( $res->gallery ){
                    foreach( $res->gallery as $img){
                        File::delete($img->path .'/' . $img->filename);
                        $img->delete();
                    }
                }
                if( $res->attach ){

                    File::delete($res->attach->path .'/' . $res->attach->filename);
                    $res->attach->delete();
                }

                $res->delete();
            }
            return response()->json(['code' => 200, 'message' => 'Delete success'],200);
        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }
    }
    public function record($request,$row){
        $row->subject   = $request['subject'];
        $row->description = $request['description'];
        $row->detail    = $request['detail'];
        $row->sortable  = $request['sortable'];
        $row->user_id   = 0;
        $row->published = $request['publish'];
        $row->save();
    }

    public function sortable($type){
        $row = Files::type( $type )->orderBy('sortable','desc')->first();
        return $row ? $row->sortable+1 : 1;
    }

    public function active(Request $request,$id){
        try{
            // echo 'id : '. $id ;
            // printr($request->all());
            $row = Article::find($id);
            $row->published = $request->input('publish') == 'true' ? 1 : 0;
            $row->save();
            return response()->json([
                'code' => 200,
                'data' => article_field($row),
            ]);
        }catch( Exception $e){
            return response()->json([
                'message'   => 'Errors sortable (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }
    }
}
