<?php

namespace App\Http\Controllers\Services;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Article;
use Exception;
use Illuminate\Support\Facades\File;
use Intervention\Image\Facades\Image;
use App\Models\Files;

class ContentsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try{

            $row = Article::type($request->input('type'))->first();
            $data = [];
            if( $row ){
                $data = [
                    'id'            => $row->id,
                    'category'      => json_decode($row->category),
                    'subject'       => json_decode($row->subject),
                    'tags'          => json_decode($row->tags),
                    'description'   => json_decode($row->description),
                    'detail'        => json_decode($row->detail),
                    'viewed'        => $row->viewed,
                    'sortable'      => $row->sortable,
                    'type'          => $row->type,
                    'user_id'       => $row->user_id,
                    'icons'        => files_rows( $row->icons ),
                    'published'     => $row->published,
                    'created_at'    => $row->created_at,
                    'updated_at'    => $row->updated_at

                ];
            }
            return response()->json([
                'data'          => $data,
                'code'          => 200

            ],200);
        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors query index (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{
            $chk = Article::type($request->input('type'))->first();
            $row = $chk ? $chk : new Article;
            $row->viewed = 0;
            $this->record($request,$row);
            return response()->json([
                        'code' => 200,
                        'data' => article_field($row)
                    ]);

        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors add (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{
            // printr( $request->all() );
            $row = Article::find($id);
            $this->record($request,$row);
            return response()->json([
                        'code' => 200,
                        'data' => article_field($row)
                    ]);
        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function record($request,$row){
        // printr($request->all());
        $category       = json_decode($request['category']);
        $row->subject   = $request['subject'];
        $row->description = $request['description'];
        $row->detail    = $request['detail'];
        $row->sortable  = 1;
        $row->published = $request['publish'];
        $row->type      = $request['type'];
        $row->user_id   = auth()->user()->id;
        // $row->category  = '';
        $row->save();
    }
}
