<?php

namespace App\Http\Controllers\Services;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\User;
use Exception;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Auth;
class AuthController extends Controller
{
    use AuthenticatesUsers;
    public function login(Request $request){
        try{
            // printr($request->all());
                if( Auth::attempt([
                                'email' => trim($request->input('email')),
                                'password' => trim($request->input('password')),
                                'level' => 'admin',
                                'status' => 'active'
                            ],
                            $request->has('remember') )
                    ){
                    $user = auth()->user();
                    $token = $user->createToken('AuthToken')->accessToken;
                    return response()->json([
                                'token'     => $token,
                                'data'      => Auth::user(),
                                'code'      => 200,
                                'message'   => 'Login success.'
                            ]);
                }else{
                    return response()->json(['message'   => 'ชื่อผู้ใช้หรือรหัสผ่านผิดพลาด','code' => 201]);
                }
        }catch(Exception $e){
            return response()->json([
                                'code' => 201,
                                'message'   => 'Errors (' . $e->getCode() .') '. $e->getMessage()
                            ]);
        }
    }

    public function getUser(){
        try{
            $user = auth()->user();
            $user->avatar_img = '';
            if( $user->avatar ){
                if( file_exists('assets/images/avatars/'.$user->avatar ))
                    $user->avatar_img = 'assets/images/avatars/'.$user->avatar;
            }
            return response()->json(auth()->user(),200);
        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ]);
        }
    }

    public function logout()
    {
        // try{
            // Auth::user()->AauthAcessToken()->delete();
            Auth::logout();
            return response()
                    ->json([
                        'logout' => true,
                        'code' => 200
                    ]);
        // }catch (Exception $e){
        //     return response()->json([
        //         'message'   => 'Errors (' . $e->getCode() .') '. $e->getMessage(),
        //         'code' => 401
        //     ]);
        // }
    }
}
