<?php

namespace App\Http\Controllers\Services;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Files;
use App\Models\Article;

use Exception;
use Illuminate\Support\Facades\File;

class ApiController extends Controller
{

    public function uniform()
    {
        try{
            $rows = Files::type('uniform')
                            ->active()
                            ->orderBy('sortable','asc')
                            ->get();
            return response()->json([
                'data'          => files_rows($rows),
                'totalRows'     => count($rows),
                'code'          => 200,

            ],200);
        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }
    }

    public function article(){
        try{
            $rows = Article::get();
            return response()->json([
                'data'          => article_rows($rows),
                'totalRows'     => count($rows),
                'code'          => 200,

            ],200);
        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors query index (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }
    }

    public function education(){
        try{
            $rows = Article::type('admission')->first();
            return response()->json([
                'data'          => article_field($rows),
                'code'          => 200,

            ],200);
        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors query index (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }
    }
}
