<?php

namespace App\Http\Controllers\Services;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Article;
use Exception;
use Illuminate\Support\Facades\File;
use Intervention\Image\Facades\Image;
use App\Models\Files;

class AdmissionController extends Controller
{
    public function __construct()
    {
        $this->upload_path = 'assets/images/upload/';
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try{

            $row = Article::type('admission')->first();
            $data = [];
            if( $row ){
                $data = [
                    'id'            => $row->id,
                    'category'      => json_decode($row->category),
                    'subject'       => json_decode($row->subject),
                    'tags'          => json_decode($row->tags),
                    'description'   => json_decode($row->description),
                    'detail'        => json_decode($row->detail),
                    'viewed'        => $row->viewed,
                    'sortable'      => $row->sortable,
                    'type'          => $row->type,
                    'user_id'       => $row->user_id,
                    'icons'        => files_rows( $row->icons ),
                    'published'     => $row->published,
                    'created_at'    => $row->created_at,
                    'updated_at'    => $row->updated_at

                ];
            }
            return response()->json([
                'data'          => $data,
                'code'          => 200

            ],200);
        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors query index (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{
            $chk = Article::type($request->input('type'))->first();
            $row = $chk ? $chk : new Article;
            $row->viewed = 0;
            $this->record($request,$row);
            return response()->json([
                        'code' => 200,
                        'data' => article_field($row)
                    ]);

        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors add (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{
            // printr( $request->all() );
            $row = Article::find($id);
            $this->record($request,$row);
            return response()->json([
                        'code' => 200,
                        'data' => article_field($row)
                    ]);
        }catch (Exception $e){
            return response()->json([
                'message'   => 'Errors (' . $e->getCode() .') '. $e->getMessage(),
                'code' => 401
            ],401);
        }    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function record($request,$row){
        // printr($request->all());
        $detail = $this->detail_file($request,$row);
        $row->subject   = $request['subject'];
        $row->description = $request['description'];
        $row->detail    = $detail;
        $row->sortable  = 1;
        $row->published = $request['publish'];
        $row->type      = $request['type'];
        $row->user_id   = auth()->user()->id;
        // $row->category  = '';
        $row->save();
    }

    public function detail_file($request,$row){
        $detail = @json_decode( $request['detail']);
        $rDetail = @json_decode( $row->detail );
        $option_th1 = $detail->th->option1;
        $option_th2 = $detail->th->option2;
        $option_th3 = $detail->th->option3;
        $option_en1 = $detail->en->option1;
        $option_en2 = $detail->en->option2;
        $option_en3 = $detail->en->option3;

        if( $request->hasFile('file_th1') && $option_th1 == 'file'){
            @File::delete( $rDetail->th->link1 );
            $file   = $request->file('file_th1');
            $path   =   makedir( $this->upload_path );
            $cname  =  'admission-link-1-th-'. date('Ymd-his') . '.' . $file->getClientOriginalExtension();
            $filename   = filename( $path , $cname );
            $file->move($path,$filename);
            $detail->th->link1 = asset( $this->upload_path . $filename );
            sleep(2);
        }

        if( $request->hasFile('file_th2') && $option_th2 == 'file'){
            @File::delete( $rDetail->th->link2 );
            $file   = $request->file('file_th2');
            $path   =   makedir( $this->upload_path );
            $cname  =  'admission-link-2-th-'. date('Ymd-his') . '.' . $file->getClientOriginalExtension();
            $filename   = filename( $path , $cname );
            $file->move($path,$filename);
            $detail->th->link2 = asset( $this->upload_path . $filename );
            sleep(2);
        }

        if( $request->hasFile('file_th3') && $option_th3 == 'file'){
            @File::delete( $rDetail->th->link3 );
            $file   = $request->file('file_th3');
            $path   =   makedir( $this->upload_path );
            $cname  =  'admission-link-3-th-'. date('Ymd-his') . '.' . $file->getClientOriginalExtension();
            $filename   = filename( $path , $cname );
            $file->move($path,$filename);
            $detail->th->link3 = asset( $this->upload_path . $filename );
            sleep(2);
        }

        if( $request->hasFile('file_en1') && $option_en1 == 'file'){
            @File::delete( $rDetail->en->link1 );
            $file   = $request->file('file_en1');
            $path   =   makedir( $this->upload_path );
            $cname  =  'admission-link-1-en-'. date('Ymd-his') . '.' . $file->getClientOriginalExtension();
            $filename   = filename( $path , $cname );
            $file->move($path,$filename);
            $detail->en->link1 = asset( $this->upload_path . $filename );
            sleep(2);
        }

        if( $request->hasFile('file_en2') && $option_en2 == 'file'){
            @File::delete( $rDetail->en->link2 );
            $file   = $request->file('file_en2');
            $path   =   makedir( $this->upload_path );
            $cname  =  'admission-link-2-en-'. date('Ymd-his') . '.' . $file->getClientOriginalExtension();
            $filename   = filename( $path , $cname );
            $file->move($path,$filename);
            $detail->en->link2 = asset( $this->upload_path . $filename );
            sleep(2);
        }

        if( $request->hasFile('file_en3') && $option_en3 == 'file'){
            @File::delete( $rDetail->en->link3 );
            $file   = $request->file('file_en3');
            $path   =   makedir( $this->upload_path );
            $cname  =  'admission-link-3-en-'. date('Ymd-his') . '.' . $file->getClientOriginalExtension();
            $filename   = filename( $path , $cname );
            $file->move($path,$filename);
            $detail->en->link3 = asset( $this->upload_path . $filename );
            sleep(2);
        }
        // printr($detail);
        return \jsonEncode($detail);
    }
}
